#!/bin/sh

# Invoke the extractrc script on all .ui, .rc, and .kcfg files in the sources.
# The results are stored in a pseudo .cpp file to be picked up by xgettext.
lst=`find . -name \*.rc -o -name \*.ui -o -name \*.kcfg`
if [ -n "$lst" ] ; then
    $EXTRACTRC $lst >> rc.cpp
fi

# If your framework contains tips-of-the-day, call preparetips as well.
if [ -f "data/tips" ] ; then
    ( cd data && $PREPARETIPS > ../tips.cpp )
fi

# Extract strings from all source files.
# If your framework depends on KI18n, use $XGETTEXT. If it uses Qt translation
# system, use $EXTRACT_TR_STRINGS.
$EXTRACT_TR_STRINGS `find . -name \*.cpp -o -name \*.h -name \*.qml` -o $podir/kdbusaddons5.pot
